<?php
/**
 * --------------------------------------------------------
 * 📦 Утилита для дампа структуры проекта и сбора кода
 * --------------------------------------------------------
 * Этот PHP-скрипт:
 * - Рекурсивно обходит директории от текущего каталога
 * - Выводит древовидную структуру всех папок и файлов
 * - Сохраняет содержимое всех .php и .css файлов в один файл
 *
 * Использование:
 * 1. Поместите скрипт в корень проекта (например, dump_project.php)
 * 2. Откройте его в браузере: https://ваш_домен/dump_project.php
 * 3. После выполнения:
 *    - В браузере будет отображена структура проекта
 *    - В файл `project_dump.txt` будет сохранён весь код
 *
 * --------------------------------------------------------
 * 🧑‍💻 Разработчик: Пыников Дмитрий
 * 🌐 Сайт: https://pynikov.org
 * ✉️ Email: dmitry@pynikov.org
 * 💼 Проекты под ключ: PHP, базы данных, веб-разработка
 * --------------------------------------------------------
 */

$outputFile = __DIR__ . '/project_dump.txt';

$skipDirs = ['vendor', 'node_modules', '.git'];
$skipFiles = [basename(__FILE__)];
$extensionsToDump = ['php', 'css'];

function scanDirectoryTree($dir, $indent = '', $fh = null): string {
    global $skipDirs, $skipFiles, $extensionsToDump;
    $result = '';
    if (!is_readable($dir)) return $indent . "[Недоступна] $dir\n";
    $files = scandir($dir);
    if (!$files) return $indent . "[Ошибка чтения] $dir\n";

    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;
        $fullPath = $dir . DIRECTORY_SEPARATOR . $file;

        if (is_dir($fullPath)) {
            if (in_array($file, $skipDirs)) continue;
            $result .= $indent . "📁 $file\n";
            $result .= scanDirectoryTree($fullPath, $indent . "    ", $fh);
        } else {
            if (in_array($file, $skipFiles)) continue;
            $result .= $indent . "📄 $file\n";

            $fileExtension = pathinfo($file, PATHINFO_EXTENSION);
            if (in_array($fileExtension, $extensionsToDump)) {
                $content = file_get_contents($fullPath);
                if ($content !== false) {
                    fwrite($fh, "\n\n============================\n");
                    fwrite($fh, "Файл: $fullPath\n");
                    fwrite($fh, "============================\n");
                    fwrite($fh, $content);
                }
            }
        }
    }
    return $result;
}

$fh = fopen($outputFile, 'w');
if (!$fh) die("❌ Не удалось создать или открыть файл: $outputFile");

fwrite($fh, "📦 Сборка проекта\n");
fwrite($fh, "Дата: " . date('Y-m-d H:i:s') . "\n");
fwrite($fh, str_repeat('=', 40) . "\n");

$structure = scanDirectoryTree(__DIR__, '', $fh);

fclose($fh);

echo "<pre>";
echo "📂 Структура вашего проекта (от корня):\n\n";
echo $structure;
echo "\n\n✅ Содержимое .php и .css файлов собрано в:\n  " . basename($outputFile);
echo "</pre>";
?>