# 📦 PHP-утилита для дампа структуры проекта и сбора кода

Этот простой, но полезный PHP-скрипт рекурсивно обходит директории проекта, формирует древовидную структуру папок и файлов, а также сохраняет содержимое всех `.php` и `.css` файлов в один текстовый файл.

## 🚀 Возможности

- 🔍 Рекурсивный обход всех директорий от текущей папки
- 🌲 Вывод структуры проекта в виде дерева
- 📄 Сбор содержимого `.php` и `.css` файлов
- 📝 Запись всего кода в `project_dump.txt`
- 🧹 Исключение определённых директорий и файлов из обхода (`vendor`, `.git` и др.)

## 🛠 Использование

1. Поместите файл скрипта в корень вашего проекта, например `dump_project.php`
2. Откройте его в браузере:  
   `https://ваш_домен/dump_project.php`
3. После выполнения:
   - В браузере отобразится структура проекта
   - В текущей директории появится файл `project_dump.txt` со всем собранным кодом

## ⚙️ Настройки

```php
$skipDirs = ['vendor', 'node_modules', '.git']; // Папки, которые не нужно сканировать
$extensionsToDump = ['php', 'css'];             // Какие расширения собирать
```

## 📂 Пример вывода

```
📁 app
    📄 index.php
    📁 controllers
        📄 MainController.php
📁 assets
    📄 style.css
```

## 👨‍💻 Разработчик

**Пыников Дмитрий**  
🌐 https://pynikov.org  
✉️ dmitry@pynikov.org  
💼 PHP, базы данных, веб-разработка под ключ

## 📄 Лицензия

Этот скрипт распространяется свободно. Можно использовать, адаптировать и распространять без ограничений.
